$ErrorActionPreference="SilentlyContinue"
Stop-Transcript | out-null
$ErrorActionPreference = "Continue"
#Requires -Version 2.0
[string] $FilenameTranscript = $MyInvocation.MyCommand.Name + " " + (hostname)+ " {0:yyyy-MM-dd hh-mmtt}.log" -f (Get-Date)
Start-Transcript -path .\$FilenameTranscript | Out-Null
$error.clear()

clear

Write-Host "##########################################################################"
Write-Host "#     Fenestrae Bulk user activation                                     #"
Write-Host "#                                                                        #" 
Write-Host "##########################################################################" 
Write-Host "#   Author      : Karl Bustamante                                        #" 
Write-Host "#   Date        : 08.02.2013                                             #" 
Write-Host "#   Version     : 1.0                                                    #" 
Write-Host "#   Comment     : This program is used to activate bulk users for        #"
Write-Host "#                 Fenestrae Faxination Server                            #" 
Write-Host "#   Modified by :                                                        #"
Write-Host "#   Date        :                                                        #"
Write-Host "#   Comment     :                                                        #"
Write-Host "#                                                                        #" 
Write-Host "##########################################################################" 
Write-Host " "

Write-Host "Press any key to continue ..." -ForegroundColor yellow
$x = $host.UI.RawUI.ReadKey("NoEcho,IncludeKeyDown")

function criticalError{
Write-Host "Error" -ForegroundColor black -backgroundcolor red
Stop-Transcript
Write-Host "Press any key to continue ..." -ForegroundColor yellow
$x = $host.UI.RawUI.ReadKey("NoEcho,IncludeKeyDown")
exit
}

#Variables

#Strings
$strCSVPath = ".\fenestraeusers.csv"			# CSV File path


# Detect correct OS here and exit if no match (we intentionally truncate the last character to account for service packs)
Write-Host "System Version (OS) : " -NoNewLine
Write-Host (Get-WMIObject win32_OperatingSystem).Version -NoNewLine

if ((Get-WMIObject win32_OperatingSystem).Version -notmatch '6.1.760'){
	Write-Host "..............................[    ERROR   ]" -ForeGroundColor red
	Write-Host "`nThis script requires a version of Windows Server 2008 R2, which this is not. Exiting...`n" -ForegroundColor Red
	Stop-Transcript
	Write-Host "Press any key to continue ..." -ForegroundColor yellow
	$x = $host.UI.RawUI.ReadKey("NoEcho,IncludeKeyDown")
	Exit
} #end OS detection
Write-Host "..............................[     OK!    ]" -ForeGroundColor Green

 
 

# checking if csv path is ok
Write-Host " - Checking if CSV '$strCSVPath' is available " -NoNewLine 
if(Test-Path -PathType leaf -Path $strCSVPath)
{
    Write-Host ".....[     OK!    ]" -ForeGroundColor green
	Write-Host " - Reading data in $strCSVPath" -NoNewLine
	$csvUsers = Import-Csv -path '.\fenestraeusers.csv' -delimiter ';'
	Write-Host ".....................[     OK!    ]" -ForeGroundColor green
}
else
{
	Write-Host ".....[    ERROR   ]" -ForeGroundColor red
	Write-Error "`nFile not found"
	criticalError
}

# Function to test if AD module is available
Function Get-MyModule { 
	Param([string]$name) 
	if(-not(Get-Module -name $name)) 
	{ if(Get-Module -ListAvailable | Where-Object { $_.name -eq $name }) 
	{ Import-Module -Name $name 
	Write-Host "`nThe"  -NoNewLine
	Write-Host " <$name> "  -ForegroundColor yellow -NoNewLine
	Write-Host "module has been loaded!"

	} 
	else { Write-Host -BackgroundColor Red "`n<$name>" -NoNewLine 
	Write-Host " module has not been loaded " -BackgroundColor Red -ForegroundColor yellow
	criticalError
	}
	} # end if not module 
	else {
		Write-Host "`nThe" -NoNewLine
		Write-Host " <$name> "  -ForegroundColor yellow -NoNewLine
		Write-Host "module is already loaded!" } 
	}
Get-Mymodule -name "ActiveDirectory"



Write-Host "--------------------------------------------------------------------------" -ForegroundColor green
Write-Host "Press any key to continue ..." -ForegroundColor yellow
$x = $host.UI.RawUI.ReadKey("NoEcho,IncludeKeyDown")
Write-Host "--------------------------------------------------------------------------" -ForegroundColor green

#Users creation
foreach($User in $csvUsers)
{

$login = $user.samaccountname
$facsimileTelephoneNumber = $user.facsimileTelephoneNumber
$dir = $user.dir
$fenUMOurCSID = $user.fenUMOurCSID
$fenUMAllowChargecodeOverride = $user.fenUMAllowChargecodeOverride
$fenUMAllowCoversheetOverride = $user.fenUMAllowCoversheetOverride
$fenUMAllowedToSendFax = $user.fenUMAllowedToSendFax
$fenUMAllowedToSendFaxInt = $user.fenUMAllowedToSendFaxInt
$fenUMAllowedToSendSms = $user.fenUMAllowedToSendSms
$fenUMAllowedToSendSmsInt = $user.fenUMAllowedToSendSmsInt
$fenUMAllowOurCSIDOverride = $user.fenUMAllowOurCSIDOverride
$fenUMAllowSMSTemplateOverride = $user.fenUMAllowSMSTemplateOverride
$fenUMCoversheet = $user.fenUMCoversheet
$fenUMFileformat = $user.fenUMFileformat
$fenUMMailTemplate = $user.fenUMMailTemplate
	
	Write-Host "--------------------------------------------------------------------------" -ForegroundColor cyan
	Write-Host " samAccountName         : $login" -ForegroundColor cyan
	Write-Host " FAX Number             : $facsimileTelephoneNumber" -ForegroundColor cyan
	Write-Host " CSID                   : $fenUMOurCSID" -ForegroundColor cyan
	Write-Host " DIR Number proxyaddress: $dir" -ForegroundColor cyan
	Write-Host " Coversheet             : $fenUMCoversheet" -ForegroundColor cyan
	Write-Host " File Format            : $fenUMFileformat" -ForegroundColor cyan
	Write-Host " Mail Template          : $fenUMMailTemplate" -ForegroundColor cyan
	Write-Host " ChargeCode Override    : $fenUMAllowChargecodeOverride" -ForegroundColor cyan
	Write-Host " CoversheetOverride     : $fenUMAllowCoversheetOverride" -ForegroundColor cyan
	Write-Host " Send FAX               : $fenUMAllowedToSendFax" -ForegroundColor cyan
	Write-Host " Send FAX International : $fenUMAllowedToSendFaxInt" -ForegroundColor cyan
	Write-Host " Send SMS               : $fenUMAllowedToSendSms" -ForegroundColor cyan
	Write-Host " Send SMS International : $fenUMAllowedToSendSmsInt" -ForegroundColor cyan
	Write-Host " CSID Override          : $fenUMAllowOurCSIDOverride" -ForegroundColor cyan
    Write-Host " SMS Template Override  : $fenUMAllowSMSTemplateOverride" -ForegroundColor cyan
	
	
	Write-Host "$login..................................................[" -NoNewLine
	Write-Host "   Creating   " -ForegroundColor yellow -NoNewLine
	Write-Host "]" -NoNewLine
	
	
	if ($facsimileTelephoneNumber -ne ""){
		$a = "Set-ADUser " + $login + " -Replace @{facsimileTelephoneNumber='" + $facsimileTelephoneNumber + "'}"
		Invoke-Expression $a
	}
	if ($fenUMAllowChargecodeOverride -ne ""){
		$b = "Set-ADUser " + $login + " -Replace @{'fen-UM-AllowChargecodeOverride'='" + $fenUMAllowChargecodeOverride + "'}"
		Invoke-Expression $b
	}
	if ($fenUMAllowCoversheetOverride -ne ""){
		$c = "Set-ADUser " + $login + " -Replace @{'fen-UM-AllowCoversheetOverride'='" + $fenUMAllowCoversheetOverride + "'}"
		Invoke-Expression $c
	}
	if ($fenUMAllowedToSendFax -ne ""){
		$d = "Set-ADUser " + $login + " -Replace @{'fen-UM-AllowedToSendFax'='" + $fenUMAllowedToSendFax + "'}"
		Invoke-Expression $d
	}
	if ($fenUMAllowedToSendFaxInt -ne ""){
		$e = "Set-ADUser " + $login + " -Replace @{'fen-UM-AllowedToSendFaxInt'='" + $fenUMAllowedToSendFaxInt + "'}"
		Invoke-Expression $e
	}
	if ($fenUMAllowedToSendSms -ne ""){
		$f = "Set-ADUser " + $login + " -Replace @{'fen-UM-AllowedToSendSms'='" + $fenUMAllowedToSendSms + "'}"
		Invoke-Expression $f
	}
	if ($fenUMAllowedToSendSmsInt -ne ""){
		$g = "Set-ADUser " + $login + " -Replace @{'fen-UM-AllowedToSendSmsInt'='" + $fenUMAllowedToSendSmsInt + "'}"
		Invoke-Expression $g
	}
	if ($fenUMAllowOurCSIDOverride -ne ""){	
		$h = "Set-ADUser " + $login + " -Replace @{'fen-UM-AllowOurCSIDOverride'='" + $fenUMAllowOurCSIDOverride + "'}"
		Invoke-Expression $h
	}	
	if ($fenUMAllowSMSTemplateOverride -ne ""){	
		$i = "Set-ADUser " + $login + " -Replace @{'fen-UM-AllowSMSTemplateOverride'='" + $fenUMAllowSMSTemplateOverride + "'}"
		Invoke-Expression $i
	}	
	if ($fenUMCoversheet -ne ""){		
		$j = "Set-ADUser " + $login + " -Replace @{'fen-UM-Coversheet'='" + $fenUMCoversheet + "'}"
		Invoke-Expression $j
	}
	if ($fenUMFileformat -ne ""){		
		$k = "Set-ADUser " + $login + " -Replace @{'fen-UM-Fileformat'='" + $fenUMFileformat + "'}"
		Invoke-Expression $k
	}
	if ($fenUMMailTemplate -ne ""){		
		$l = "Set-ADUser " + $login + " -Replace @{'fen-UM-MailTemplate'='" + $fenUMMailTemplate + "'}"
		Invoke-Expression $l
	}
	if ($dir -ne ""){		
		$m = "Set-ADUser " + $login + " -Add @{proxyAddresses = '" + $dir + "'}"
		Invoke-Expression $m
	}
	if ($fenUMOurCSID -ne ""){		
		$n = "Set-ADUser " + $login + " -Replace @{'fen-UM-OurCSID'='" + $fenUMOurCSID + "'}"
		Invoke-Expression $n
	}	
	
	Write-Host "`b`b`b`b`b`b`b`b`b`b`b`b`b`b     OK!" -ForegroundColor green -NoNewLine
	Write-Host "     ]"
}

Write-Host "--------------------------------------------------------------------------" -ForegroundColor green
Stop-Transcript
Write-Host "--------------------------------------------------------------------------" -ForegroundColor green
Write-Host "Press any key to exit ..." -ForegroundColor yellow

$x = $host.UI.RawUI.ReadKey("NoEcho,IncludeKeyDown")


